/*
 * Decompiled with CFR 0.152.
 */
package courseenrollment;

import courseenrollment.Course;
import courseenrollment.Database;
import courseenrollment.Department;
import courseenrollment.Student;
import java.util.HashMap;
import java.util.Scanner;

public class Client {
    static final String BANNER = "STUDENT COURSE ENROLLMENT\n-------------------------\n";
    static int id;
    static String passwd;
    static Scanner stdin;
    static HashMap<Integer, Student> students;
    static Student user;
    static char option;
    static Course current;
    static boolean repeat;

    public static void main(String[] args) {
        students.put(55555, new Student("John", "Smith", Department.CS, "P@55w0rd"));
        Database.createCourseList();
        System.out.println(BANNER);
        do {
            System.out.print("Enter Student ID: ");
            id = stdin.nextInt();
            System.out.print("Enter Password: ");
        } while (!Client.login(id, passwd = stdin.next()));
        block9: do {
            System.out.println();
            System.out.println("What would you like to do?");
            System.out.println("1. [A]dd course");
            System.out.println("2. [D]rop course");
            System.out.println("3. [L]ist courses");
            System.out.println("4. [V]iew course description");
            System.out.println("5. View [S]chedule");
            System.out.println("6. [Q]uit");
            System.out.print("Enter an option: ");
            option = stdin.next().toUpperCase().charAt(0);
            switch (option) {
                case '1': 
                case 'A': {
                    System.out.print("Select a course to enroll in: ");
                    current = Database.courses.get(stdin.next().toUpperCase());
                    if (current == null) {
                        System.err.println("Course not found!");
                        break;
                    }
                    System.out.println("Enrolling in " + current + "...");
                    user.addCourse(current);
                    break;
                }
                case '2': 
                case 'D': {
                    System.out.print("Select a course to drop: ");
                    current = Database.courses.get(stdin.next().toUpperCase());
                    if (current == null) {
                        System.err.println("Course not found!");
                        break;
                    }
                    System.out.println("Dropping " + current + "...");
                    user.dropCourse(current);
                    break;
                }
                case '3': 
                case 'L': {
                    Client.listCourses();
                    break;
                }
                case '4': 
                case 'V': {
                    System.out.print("Select a course to describe: ");
                    current = Database.courses.get(stdin.next().toUpperCase());
                    if (current == null) {
                        System.err.println("Course not found!");
                        break;
                    }
                    System.out.printf("Course #: %s%nDepartment: %s%nName: %s%nRoom: %s%nProfessor: %s%n", new Object[]{current, Client.current.dept, Client.current.name, Client.current.hall, Client.current.professor});
                    break;
                }
                case '5': 
                case 'S': {
                    if (user.getSchedule().isEmpty()) {
                        System.out.println("You have not signed up for any courses.");
                        break;
                    }
                    System.out.println("Courses for" + user + " :");
                    for (Course c : user.getSchedule()) {
                        System.out.println("* " + c);
                    }
                    continue block9;
                }
                case '6': 
                case 'Q': {
                    System.out.print("Are you sure you want to quit? (Y/N) ");
                    repeat = stdin.next().toUpperCase().charAt(0) != 'Y';
                    break;
                }
                default: {
                    System.err.println("INVALID OPTION!");
                }
            }
        } while (repeat);
        System.out.println("Goodbye, " + user + "!");
    }

    public static boolean login(int id, String passwd) {
        user = students.get(id);
        boolean valid = user != null && user.authenticate(passwd);
        System.out.println(valid ? "Welcome, " + user + "!" : "Invalid student ID or password!");
        return valid;
    }

    public static void listCourses() {
        System.out.println("Available Courses:");
        for (String s : Database.courses.keySet()) {
            System.out.println("* " + s);
        }
    }

    static {
        stdin = new Scanner(System.in);
        students = new HashMap();
        repeat = true;
    }
}

